// admin/assets/js/hio-script.js

jQuery(document).ready(function($) {
    // Renamed from MIO_Data to HIO_Data
    const data = HIO_Data;
    let current_settings = data.initial_settings;
    let total_images = data.images_to_process;
    let is_processing = false;

    // --- UI Rendering Function (Minimal Modern Look) ---
    function renderDashboard() {
        const settingsHtml = `
            <div class="hio-card settings-panel">
                <h2>Conversion Settings</h2>
                <div class="hio-setting-row">
                    <label for="hio-on-upload-enabled">Automatically Convert Images on Upload</label>
                    <input type="checkbox" id="hio-on-upload-enabled" ${current_settings.on_upload_enabled ? 'checked' : ''}>
                    <span class="hio-switch"></span>
                </div>
                <div class="hio-setting-row">
                    <label for="hio-target-format">Target Format</label>
                    <select id="hio-target-format">
                        <option value="webp" ${current_settings.target_format === 'webp' ? 'selected' : ''}>WebP</option>
                        <option value="avif" ${current_settings.target_format === 'avif' ? 'selected' : ''}>AVIF</option>
                    </select>
                </div>
                <div class="hio-setting-row">
                    <label for="hio-quality-slider">Quality (${current_settings.conversion_quality}%)</label>
                    <input type="range" id="hio-quality-slider" min="50" max="100" value="${current_settings.conversion_quality}">
                </div>
                <div class="hio-setting-row">
    <label for="hio-serving-method">Serving Method</label>
    <select id="hio-serving-method">
        <option value="picture" ${current_settings.serving_method === 'picture' ? 'selected' : ''}>Picture / Srcset (Recommended)</option>
        <option value="htaccess" ${current_settings.serving_method === 'htaccess' ? 'selected' : ''}>.htaccess Rewrite (Server Side)</option>
    </select>
    <p class="description">Choose how optimized images are served to browsers.</p>
</div>
<div id="hio-status-log2"></div>
                <button id="hio-save-settings" class="button button-primary">Save Settings</button>
                <p id="hio-save-status"></p>
                
            </div>
        `;

        const bulkHtml = `
            <div class="hio-card bulk-panel">
                <h2>Bulk Image Optimization</h2>
                <p>Images to process: <strong id="hio-total-count">${total_images}</strong></p>
           
                <div class="hio-progress-container">
                    <div id="hio-progress-bar" style="width: 0%;"></div>
                    <span id="hio-progress-text">0%</span>
                </div>
                
                <div style="display: flex; align-items: center; gap: 10px; margin-top: 10px; flex-wrap: wrap;">
    <button id="hio-start-bulk" class="button button-primary button-hero" ${is_processing || total_images === 0 ? 'disabled' : ''}>
        ${is_processing ? 'Processing...' : 'Start Bulk Conversion'}
    </button>
    <button id="hio-start-background" class="button button-primary button-hero">
        Bulk Optimization in Background (PRO Feature)
    </button>
</div>
<p id="hio-status-log"></p>
<div id="hio-background-status" style="margin-top:8px;"></div>
            </div>
        `;

        // Renamed ID from mio-app to hio-app (though not strictly necessary here, it's good practice)
        $('#hio-dashboard').html(settingsHtml + bulkHtml);
        attachEventListeners();
    }

    // --- Event Handlers ---
    function attachEventListeners() {
        $('#hio-start-bulk').on('click', startBulkConversion);
        $('#hio-save-settings').on('click', saveSettings);

        $('#hio-quality-slider').on('input', function() {
            // Update the percentage label dynamically
            $(this).prev('label').html(`Quality (${$(this).val()}%)`);
            current_settings.conversion_quality = $(this).val();
        });
    }
    // --- AJAX Logic ---

    function saveSettings() {
        const new_settings = {
            on_upload_enabled: $('#hio-on-upload-enabled').is(':checked') ? 1 : 0,
            target_format: $('#hio-target-format').val(),
            conversion_quality: $('#hio-quality-slider').val(),
            serving_method: $('#hio-serving-method').val(),
        };

        $('#hio-save-settings').prop('disabled', true).text('Saving...');
        $('#hio-save-status').text('');

        $.post(data.ajax_url, {
            action: 'hio_save_settings', // Renamed action
            security: data.nonce,
            ...new_settings
        }, function(response) {
            $('#hio-save-settings').prop('disabled', false).text('Save Hibiscus Settings');
            if (response.success) {
                current_settings = response.data.settings;
                 $('#hio-save-status').html(
        '<span style="color:green;">' + response.data.message + '</span>' +
        '<br><small>' + response.data.htaccess + '</small>'
    );
            } else {
                $('#hio-save-status').text('Error saving settings.').css('color', 'red');
            }
        });
    }
    jQuery(document).ready(function($){$('.hio-progress-container').after('<div id="hio-support-status-message" style="margin-top: 10px;"></div>')});
    jQuery(document).ready(function($) {
        $('#hio-target-format').on('change', function () {

        });
        $('#hio-start-background').on('click', startBackgroundOptimization);
    });
    function startBulkConversion() {
        const selectedFormat = $("#hio-target-format").val();
        const statusMessage = $('#hio-support-status-message');
        const flg = false;
        statusMessage.empty();

        if (selectedFormat === 'avif' || selectedFormat === 'webp') {
            const formatName = (selectedFormat === 'avif' ? 'AVIF' : 'WebP');
            statusMessage.html(`<p style="color:#0073aa;">Checking server ${formatName} support...</p>`);
            // Send AJAX request to check server capability
            $.ajax({
                url: HIO_Data.ajax_url,
                type: 'POST',
                data: {
                    action: 'hio_check_format_support', // Updated action name
                    nonce: HIO_Data.nonce,
                    format: selectedFormat // Send the selected format
                },
                success: function (response) {
                    if (response.success && response.data.supported) {
                        statusMessage.html(`<p style="color:green;">✅ **Success!** ${formatName} conversion is fully supported on your server.</p>`);
                        if (is_processing) return;
                        is_processing = true;

                        // Reset UI
                        $('#hio-start-bulk').prop('disabled', true).text('Processing...');
                        $('#hio-status-log').text('Starting Hibiscus conversion...');
                        $('#hio-progress-bar').css('width', '0%');
                        $('#hio-progress-text').text('0%');

                        // Start the iterative process
                        processNextBatch(0, total_images);
                    } else {
                        const reason = response.data.reason || 'unknown_error';
                        let errorMessage = `⚠️ **Warning!** ${formatName} conversion failed the server check.`;

                        // --- AVIF Errors ---
                        if (reason === 'missing_imagick') {
                            errorMessage = '❌ **AVIF Disabled:** Install the **Imagick PHP extension** to enable AVIF.';
                        } else if (reason === 'no_avif_support') {
                            errorMessage = '❌ **AVIF Disabled:** Imagick lacks the necessary **AVIF codec** support.';
                        }

                        // --- WebP Errors ---
                        else if (reason === 'missing_gd') {
                            errorMessage = '❌ **WebP Disabled:** The **GD PHP extension** is missing on your server.';
                        } else if (reason === 'no_webp_support_gd') {
                            errorMessage = '❌ **WebP Disabled:** The GD extension is installed, but it lacks **WebP support** (requires libwebp).';
                        }

                        statusMessage.html('<p style="color:red; font-weight: bold;">' + errorMessage + '</p>');
                    }
                },
                error: function () {
                    statusMessage.html('<p style="color:red;">An unknown communication error occurred while checking support.</p>');
                }
            });
        } else {
            statusMessage.empty();

        }

    }
function startBackgroundOptimization() {
    if (!HIO_Data.is_premium) {
        // If user is on free plan, open Freemius upgrade modal
        if (typeof hibiscus_fs !== 'undefined' && hibiscus_fs.isRegistered()) {
            hibiscus_fs.purchase(); // Opens Freemius purchase window
        } else {
            alert('Please upgrade to unlock background optimization.');
        }
        return;
    }

    // Continue with AJAX only if premium
    const $btn = jQuery('#hio-start-background');
    const $status = jQuery('#hio-background-status');

    $btn.prop('disabled', true).text('Starting background optimization...');
    $status.html('<span style="color:#0073aa;">⏳ Initializing background conversion...</span>');

    jQuery.ajax({
        url: HIO_Data.ajax_url,
        type: 'POST',
        dataType: 'json',
        data: {
            action: 'hio_start_background_optimization', // ✅ correct action
            security: HIO_Data.nonce
        },
        success: function (response) {
            if (response.success) {
                $status.html('<span style="color:green;">✅ ' + response.data.message + '</span>');
            } else {
                $status.html('<span style="color:red;">⚠️ ' + (response.data?.message || 'An unexpected error occurred.') + '</span>');
            }
        },
        error: function () {
            $status.html('<span style="color:red;">❌ Failed to communicate with the server.</span>');
        },
        complete: function () {
            $btn.prop('disabled', false).text('Bulk Optimization in Background');
        }
    });
}


    function processNextBatch(offset, total) {
        if (offset >= total && total > 0) {
            offset = total;
        }

        if (offset >= total && total > 0) {
            is_processing = false;
            $('#hio-start-bulk').prop('disabled', false).text('Start Bulk Conversion');
            $('#hio-status-log').text('All done! Your images have been successfully converted and optimized.');
            return;
        }

        $.post(data.ajax_url, {
            action: 'hio_bulk_convert', // Renamed action
            security: data.nonce,
            offset: offset,
            total_images: total
        }, function(response) {
            if (response.success) {
                const progress = response.data.progress;
                const next_offset = response.data.offset;

                // Update Progress Bar
                $('#hio-progress-bar').css('width', progress + '%');
                $('#hio-progress-text').text(progress + '%');
                $('#hio-status-log').text(response.data.message);

                if (!response.data.is_finished) {
                    // Process next batch after a short delay for responsiveness
                    setTimeout(() => processNextBatch(next_offset, total), 100);
                } else {
                    // Final state
                    is_processing = false;
                    $('#hio-start-bulk').prop('disabled', false).text('Start Bulk Conversion');
                    $('#hio-progress-bar').css('width', '100%');
                    $('#hio-progress-text').text('100%');
                    $('#hio-status-log').text(response.data.message);
                }
            } else {
                // Handle error
                is_processing = false;
                $('#hio-start-bulk').prop('disabled', false).text('Start Bulk Conversion');
                $('#hio-status-log').text('An error occurred during conversion.').css('color', 'red');
            }
        });
    }

    // Initialize the dashboard
    renderDashboard();
    $('#hio-serving-method').on('change', function() {
   const selected = $(this).val();
    const noticeContainer = $('#hio-status-log2');

    // Clear previous message
    noticeContainer.empty();

    if (selected === 'htaccess') {
        noticeContainer.html(`
            <div class="hio-notice hio-notice-info2">
                <strong>Note:</strong> Ensure your server supports <code>mod_rewrite</code> or Nginx rewrite rules.
                We'll automatically write .htaccess rules if available.
            </div>
        `);
    }
});
});